#!/bin/bash
#SBATCH --mem=40G
#SBATCH --cpus-per-task=4
#SBATCH --time=17:00:00              # Time limit hrs:min:sec
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/nsfw/places-%a.out    # Standard output and error log
#SBATCH --open-mode=A
#SBATCH --partition=compute
#SBATCH --job-name=nsfwdet
#SBATCH --array=0-26

cd /users/yuki/adiwol/nsfw_model

echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*100000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*100000))

in_file=_tmp_places_train_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/places/nsfw/'
mkdir -p ${results_dir}

< /users/yuki/adiwol/Places_train.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

/scratch/shared/beegfs/yuki/envs/keras/bin/python main_nsfw_detector.py \
                                                  ${in_file} \
                                                  ${SLURM_ARRAY_TASK_ID} \
                                                  ${results_dir}

